#include <iostream>
#include <vector>
#include <queue>

const int INF = 2e9;

struct Room {
  int id;
  int platform;
  int parent;
  std::vector<int> children;
};

int solve(int N, const std::vector<Room>& rooms, const std::vector<int>& changes) {
  // Build the cave structure
  for (int i = 1; i <= N; ++i) {
    rooms[i].parent = -1;
    for (int child : rooms[i].children) {
      rooms[child].parent = i;
    }
  }

  // Initialize min jumps and visited flags
  std::vector<int> min_jumps(N + 1, INF);
  min_jumps[1] = 0;
  std::vector<bool> visited(N + 1, false);

  // BFS to find minimum jumps for each rabbit
  for (int rabbit = 1; rabbit <= N; ++rabbit) {
    if (visited[rabbit]) continue;

    // Apply rabbit-specific change
    if (changes[rabbit] > 0) {
      rooms[changes[rabbit]].platform ^= 1;
    }

    std::queue<int> q;
    q.push(rabbit);
    visited[rabbit] = true;

    while (!q.empty()) {
      int current = q.front();
      q.pop();

      // Check if current room has platform and rabbit can directly escape
      if (rooms[current].platform && current == 1) {
        min_jumps[rabbit] = 1;
        break;
      }

      // Jump up the cave
      for (int parent = rooms[current].parent; parent != -1; parent = rooms[parent].parent) {
        if (rooms[parent].platform) {
          min_jumps[rabbit] = std::min(min_jumps[rabbit], 1 + min_jumps[parent]);
          break;
        }
      }

      // Explore unvisited children
      for (int child : rooms[current].children) {
        if (!visited[child]) {
          q.push(child);
          visited[child] = true;
        }
      }
    }

    // If platform was changed, revert it back
    if (changes[rabbit] > 0) {
      rooms[changes[rabbit]].platform ^= 1;
    }
  }

  // Check if rabbits were trapped
  for (int rabbit = 1; rabbit <= N; ++rabbit) {
    if (min_jumps[rabbit] == INF) {
      min_jumps[rabbit] = -1;
    }
  }

  return min_jumps;
}

int main() {
  int N;
  std::cin >> N;

  std::vector<Room> rooms(N + 1);
  for (int i = 1; i <= N - 1; ++i) {
    int u, v;
    std::cin >> u >> v;
    rooms[u].children.push_back(v);
  }

  std::vector<int> platforms(N + 1, 0);
  for (int i = 1; i <= N; ++i) {
    std::cin >> platforms[i];
  }

  std::vector<int> changes(N + 1, 0);
  for (int i = 1; i <= N; ++i) {
    std::cin >> changes[i];
  }

  std::vector<int> min_jumps = solve(N, rooms, changes);

  for (int i = 1; i <= N; ++i) {
    std::cout << min_jumps[i] << " ";
  }
  std::cout << std::endl;

  return 0;
}